<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AcademiaFaculteFromRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'mail' => ['required', 'email'],
            'pays' => ['required'],
            'promotion' => ['required'],
            'faculte' => ['required'],
            'date' => ['required'],
            'heure' => ['required'],
        ];
    }
    public function messages(): array
    {
        return [
            'mail.required' => 'Le champ e-mail est obligatoire.',
            'mail.email' => 'Veuillez fournir une adresse e-mail valide.',
            'promotion.required' => 'Le champ promotion est obligatoire.',
            'faculte.required' => 'Le champ faculte est obligatoire.',
            'date.required' => 'Le champ date est obligatoire.',
            'heure.required' => 'Le champ heure est obligatoire.',
        ];
    }
}
